<?php
/**
 * about Tab For Theme Option.
 *
 * @package bim
 */



Redux::setSection($bim_pre,  array(
	'id' => 'general',
	'icon' => 'el el-book',
	'title' => esc_html__('General', 'bim'),
	'desc' => esc_html__('Welcome to the theme options', 'bim'),
));


Redux::setSection($bim_pre,  array(
	'id' => 'style',
	'icon' => 'el el-adjust-alt',
	"subsection" => true,
	'title' => esc_html__('Styling', 'bim'),
	'desc' => esc_html__('Configuration the style settings', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_color_general',
			'type'     => 'color',
			'title'    => esc_html__('Color Scheme', 'bim'), 
			'subtitle' => esc_html__('Pick your color scheme (default: #ce9e51).', 'bim'),
			'default'  => '#ce9e51',
			'validate' => 'color',
		), 
		array(
			'id'       => 'bim_color_scheme',
			'type'     => 'color',
			'title'    => esc_html__('Hyperlink Color', 'bim'), 
			'subtitle' => esc_html__('Pick your color for hyperlink. Default color is black #999999', 'bim'),
			'default'  => '#999999',
			'validate' => 'color',
		), 
		array(
			'id'       => 'bim_custom_hovers',
			'type'     => 'color',
			'title'    => esc_html__('Hyperlink color on hover state', 'bim'), 
			'subtitle' => esc_html__('Pick your color for hover state in hyperlink. Default color is #ce9e51', 'bim'),
			'default'  => '#ce9e51',
			'validate' => 'color',
		),  
		array(
			'id'       => 'bim_heading_color',
			'type'     => 'color',
			'title'    => esc_html__('Color on Heading', 'bim'), 
			'subtitle' => esc_html__('Pick your color for heading text. Default color is black #000000', 'bim'),
			'default'  => '#000000',
			'validate' => 'color',
		), 
		array(
			'id'       => 'bim_general_color',
			'type'     => 'color',
			'title'    => esc_html__('Color on General Paragraph', 'bim'), 
			'subtitle' => esc_html__('Pick your color for general paragraph text. Default color is black #666', 'bim'),
			'default'  => '#666',
			'validate' => 'color',
		), 
		array(
			'id'       => 'bim_stick_menu',
			'type'     => 'color',
			'title'    => esc_html__('Sticky Menu Background color (for menu with black background & All Sticky Custom Menu)', 'bim'), 
			'subtitle' => esc_html__('Pick your background color for sticky menu in white text header. Default color is #fff', 'bim'),
			'default'  => 'rgba(255,255,255,.9)',
			'validate' => 'color',
		), 
		array(
			'id'       => 'bim_stick_menu2',
			'type'     => 'color',
			'title'    => esc_html__('Sticky Menu Background color (for menu with white background)', 'bim'), 
			'subtitle' => esc_html__('Pick your background color for sticky menu in white text header. Default color is #ffffff', 'bim'),
			'default'  => '#ffffff',
			'validate' => 'color',
		), 
		 array(
			'id'       => 'bim_menu_border',
			'type'     => 'color',
			'title'    => esc_html__('Sticky Menu BBorder color (for menu with transparent background)', 'bim'), 
			'subtitle' => esc_html__('Pick your border color for sticky menu in transparent text header. Default color is #ffffff', 'bim'),
			'default'  => '#ffffff',
			'validate' => 'color',
		),
		array(
			'id'       => 'bim_footer_color',
			'type'     => 'color',
			'title'    => esc_html__('Standard Footer Background color', 'bim'), 
			'subtitle' => esc_html__('Pick your background color for standard footer. Default color is black #202020', 'bim'),
			'default'  => '#202020',
			'validate' => 'color',
		),
		array(
			'id'       => 'bim_footer_color',
			'type'     => 'color',
			'title'    => esc_html__('Standard Footer Background color', 'bim'), 
			'subtitle' => esc_html__('Pick your background color for standard footer. Default color is black #202020', 'bim'),
			'default'  => '#202020',
			'validate' => 'color',
		),
	),
));

Redux::setSection($bim_pre,  array(
	'id' => 'preloader',
	'icon' => 'el el-repeat',
	"subsection" => true,
	'title' => esc_html__('Preloader', 'bim'),
	'desc' => esc_html__('Configuration the style settings', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_preloader_set',
			'type'     => 'select',
			'title'    => esc_html__('Preloader Setting', 'bim'),
			'options' => array(
					'show_all' => esc_html__('Show in All pages', 'bim'),
					'show_home' => esc_html__('Show in Home page only', 'bim'),
					'not_show' => esc_html__('Hide in all pages', 'bim'),
				),
		),
		array(
			'id'       => 'bim_preloader_type',
			'type'     => 'select',
			'title'    => esc_html__('Preloader Type', 'bim'),
			'options' => array(
					'circle' => esc_html__('Circle', 'bim'),
					'animated_logo' => esc_html__('Animated Logo', 'bim'),
				),
		),

		array(
			'id'       => 'bim_loader_color',
			'type'     => 'color',
			'title'    => esc_html__('Color Scheme', 'bim'), 
			'subtitle' => esc_html__('Pick your color scheme (default: #ce9e51).', 'bim'),
			'default'  => '#ce9e51',
			'validate' => 'color',
		),       
	),
)); 
Redux::setSection($bim_pre,  array(
	'id' => 'cursor',
	'icon' => 'el el-thumbs-up', 
	"subsection" => true,
	'title' => esc_html__('Cursor', 'bim'),
	'desc' => esc_html__('Select your cursor type', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_cursor_set',
			'type'     => 'select',
			'customizer' => true,
			'title'    => esc_html__('Theme Cursor Type', 'bim'),
			'options' => array(
					'none' => esc_html__('Default', 'bim'),
					'1' => esc_html__('Style 1', 'bim'),
				),
			'default' => '1',
		),      
	),
));

Redux::setSection($bim_pre,  array(
	'icon' => 'el el-photo',
	"subsection" => false,
	'title' => esc_html__('Header', 'bim'),
	'desc' => esc_html__('Assign menu for header section.', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_header_set',
			'type'     => 'select',
			'title'    => esc_html__('Header type', 'bim'),
			'options' => array(
				'default' => esc_html__('Standard Header', 'bim'),
				'custom' => esc_html__('Custom Header', 'bim'),
			),
		),

		array(
			'id'    => 'bim_header_set_list',
			'type'  => 'select',
			'desc' => esc_html__('(Only if custom header selected as header type))', 'bim'),
			'title'    => esc_html__('Header format', 'bim'),
			'data'  => 'posts',
			'args'  => array(
				'post_type' => 'header',
				'orderby'   => 'title',
				'order'     => 'ASC',
			)
		),  
	),
));

Redux::setSection($bim_pre,  array(
	'id' => 'header_logo',
	'icon' => 'el el-universal-access',
	"subsection" => false,
	'title' => esc_html__('Header logo', 'bim'),
	'desc' => esc_html__('Configuration the style settings', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_header_logo_white',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__('Logo White Text', 'bim'), 
			'subtitle' => esc_html__('Upload your logo for white text (standard) header (Recommended size 240x80px)', 'bim'),
			'default'  => array('url'=>get_template_directory_uri().'/images/logo-white.png'),
		), 
		array(
			'id'       => 'bim_header_logo_dark',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__('Logo Dark Text', 'bim'), 
			'subtitle' => esc_html__('Upload your logo for dark text (standard) header (Recommended size 240x80px)', 'bim'),
			'default'  => array('url'=>get_template_directory_uri().'/images/logo.png'),
		),
		array(
			'id'       => 'bim_logo_dim',
			'type'     => 'dimensions',
			'height' => true,
             'width' => false,
			'units'    => array('em','px','%'),
			'title'    => esc_html__('Logo dimensions Height', 'bim'), 
			'subtitle' => esc_html__('Enable or disable any piece of this field. Width, Height, or Units.)', 'bim'),
			'default' => ['height' => 25], 
		), 
     
	)
));

Redux::setSection($bim_pre,  array(
	'id' => 'bim_header_social',
	'icon' => 'el el-group',
	"subsection" => false,
	'title' => esc_html__('Header social', 'bim'),
	'desc' => esc_html__('Configuration the header social icons', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_menu_position',
			'type'     => 'select',
			'title'    => esc_html__('Menu Position', 'bim'), 
			'options' => array(
				'right' => esc_html__('Right', 'bim'),
				'center' => esc_html__('Center', 'bim'),
			), 
			'default'  => 'right',
		), 
		array(
			'id'       => 'bim_header_enable_topmenu',
			'type'     => 'select',
			'title'    => esc_html__('Enable Top Menu', 'bim'),
			'options' => array(
				'on' => esc_html__('On', 'bim'),
				'off' => esc_html__('Off', 'bim'),
			), 
			'default'  => 'off',
		), 
		array(
			'id'       => 'bim_header_phone',
			'type'     => 'text',
			'title'    => esc_html__('Phone', 'bim'), 
			'subtitle' => esc_html__('Input phone number', 'bim'),
			'required'  => array('bim_header_enable_topmenu', 'equals','on'),
		),
		array(
			'id'       => 'bim_header_mail',
			'type'     => 'text',
			'title'    => esc_html__('Mail', 'bim'), 
			'subtitle' => esc_html__('Input mail address', 'bim'),
			'required'  => array('bim_header_enable_topmenu', 'equals','on'),
		),
		array(
			'id'       => 'bim_header_address',
			'type'     => 'text',
			'title'    => esc_html__('Address', 'bim'), 
			'subtitle' => esc_html__('Input address', 'bim'),
			'required'  => array('bim_header_enable_topmenu', 'equals','on'),
		),
		array(
			'id'       => 'bim_header_join',
			'type'     => 'text',
			'title'    => esc_html__('Join', 'bim'), 
			'subtitle' => esc_html__('Input Join text', 'bim'),
			'required'  => array('bim_header_enable_topmenu', 'equals','on'),
		),
		array(
			'id'       => 'bim_header_joinlink',
			'type'     => 'text',
			'title'    => esc_html__('Join', 'bim'), 
			'subtitle' => esc_html__('Input Join link', 'bim'),
			'required'  => array('bim_header_enable_topmenu', 'equals','on'),
		),
		array(
			'id'       => 'bim_header_enable_social',
			'type'     => 'select',
			'title'    => esc_html__('Enable Header Social', 'bim'),
			'options' => array(
				'on' => esc_html__('On', 'bim'),
				'off' => esc_html__('Off', 'bim'),
			), 
			'default'  => 'off',
		), 
		array(
			'id'       => 'bim_header_social_new_tab',
			'type'     => 'select',
			'title'    => esc_html__('Enable Header Social New Tab', 'iteck'),
			'options' => array(
				'on' => esc_html__('On', 'iteck'),
				'off' => esc_html__('Off', 'iteck'),
			), 
			'default'  => 'off',
			'required'  => array('bim_header_enable_social', 'equals','on'),
		), 
		array(
			'id'       => 'bim_header_facebook',
			'type'     => 'text',
			'title'    => esc_html__('Facebook Link', 'bim'), 
			'subtitle' => esc_html__('Input facebook link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		), 
		array(
			'id'       => 'bim_header_tiktok',
			'type'     => 'text',
			'title'    => esc_html__('Tiktok Link', 'bim'), 
			'subtitle' => esc_html__('Input Tiktok link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		), 
		array(
			'id'       => 'bim_header_twitter',
			'type'     => 'text',
			'title'    => esc_html__('Twitter Link', 'bim'), 
			'subtitle' => esc_html__('Input Twitter link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		), 
		array(
			'id'       => 'bim_header_instagram',
			'type'     => 'text',
			'title'    => esc_html__('Instagram Link', 'bim'), 
			'subtitle' => esc_html__('Input Instagram link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		),  
		array(
			'id'       => 'bim_header_pinterest',
			'type'     => 'text',
			'title'    => esc_html__('Pinterest Link', 'bim'), 
			'subtitle' => esc_html__('Input Pinterest link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		), 
		array(
			'id'       => 'bim_header_xing',
			'type'     => 'text',
			'title'    => esc_html__('Xing Link', 'bim'), 
			'subtitle' => esc_html__('Input Xing link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		),  
		array(
			'id'       => 'bim_header_linkedin',
			'type'     => 'text',
			'title'    => esc_html__('LinkedIn Link', 'bim'), 
			'subtitle' => esc_html__('Input LinkedIn link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		),     
		array(
			'id'       => 'bim_header_youtube',
			'type'     => 'text',
			'title'    => esc_html__('Youtube Link', 'bim'), 
			'subtitle' => esc_html__('Input Youtube link here', 'bim'),
			'required'  => array('bim_header_enable_social', 'equals','on'),
		),   
		array(
			'id'       => 'bim_header_search',
			'type'     => 'select',
			'title'    => esc_html__('Search Icon', 'bim'), 
			'subtitle' => esc_html__('To show search icon in header', 'bim'),
			'options' => array(
				'on' => esc_html__('On', 'bim'),
				'off' => esc_html__('Off', 'bim'),
			), 
			'default'  => 'off',
		), 
		array(
			'id'       => 'bim_header_cart',
			'type'     => 'select',
			'title'    => esc_html__('Cart Icon', 'bim'), 
			'subtitle' => esc_html__('To show Cart icon in header', 'bim'),
			'options' => array(
				'on' => esc_html__('On', 'bim'),
				'off' => esc_html__('Off', 'bim'),
			), 
			'default'  => 'off',
		), 
		array(
			'id'       => 'bim_header_btn',
			'type'     => 'select',
			'title'    => esc_html__('Button', 'bim'), 
			'subtitle' => esc_html__('To show Button in header', 'bim'),
			'options' => array(
				'on' => esc_html__('On', 'bim'),
				'off' => esc_html__('Off', 'bim'),
			), 
			'default'  => 'off',
		), 
		array(
			'id'       => 'bim_menu_btn',
			'type'     => 'text',
			'title'    => esc_html__('Button Text', 'bim'), 
			'required'  => array('bim_header_btn', 'equals','on'),
		),
		array(
			'id'       => 'bim_menu_btn_url',
			'type'     => 'text',
			'title'    => esc_html__('Button URL', 'bim'),
			'required'  => array('bim_header_btn', 'equals','on'), 
		),
	)
));

Redux::setSection($bim_pre,  array(
	'icon' => 'el-icon-lines',
	"subsection" => false,
	'title' => esc_html__('Footer', 'bim'),
	'desc' => esc_html__('Assign menu for footer section.', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_footer_set',
			'type'     => 'select',
			'title'    => esc_html__('Footer type', 'bim'),
			'options' => array(
				'default' => esc_html__('Standard Footer', 'bim'),
				'custom' => esc_html__('Custom Footer', 'bim'),
			),
		),
		array(
			'id'    => 'bim_footer_set_list',
			'type'  => 'select',
			'title'    => esc_html__('Footer format', 'bim'),
			'data'  => 'posts',
			'args'  => array(
				'post_type' => 'footer',
				'orderby'   => 'title',
				'order'     => 'ASC',
			)
		),     
	),
));
// -> START Blog Options
Redux::setSection($bim_pre,  array(
        'title' => esc_html__('Blog', 'bim'),
        'id' => 'blog-option',
        'icon' => 'el-icon-th',
));

Redux::setSection($bim_pre,  array(
        'title' => esc_html__('Single', 'bim'),
        'id' => 'blog-single-option',
        'subsection' => true,
        'fields' => [
            [
                'id' => 'bim_single_type_layout',
                'type' => 'button_set',
                'title' => esc_html__('Default Post Layout', 'bim'),
                'desc' => esc_html__('Note: each Post can be additionally customized within its Meta boxes section.', 'bim'),
                'options' => [
                    '1' => esc_html__('Title First', 'bim'),
                    '2' => esc_html__('Image First', 'bim'),
                    '3' => esc_html__('Overlay Image', 'bim')
                ],
                'default' => '3'
            ],
            [
                'id' => 'blog_single_page_title-start',
                'type' => 'section',
                'title' => esc_html__('Page Title', 'bim'),
                'indent' => true,
            ],
            [
                'id' => 'blog_title_conditional',
                'type' => 'switch',
                'title' => esc_html__('Page Title Text', 'bim'),
                'on' => esc_html__('Custom', 'bim'),
                'off' => esc_html__('Default', 'bim'),
                'default' => true,
            ],
            [
                'id' => 'post_single_page_title_text',
                'type' => 'text',
                'title' => esc_html__('Custom Page Title Text', 'bim'),
                'default' => esc_html__('Blog Post', 'bim'),
                'required' => ['blog_title_conditional', '=', true],
            ],
            [
                'id' => 'blog_single_page_title_breadcrumbs_switch',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'bim'),
                'on' => esc_html__('Use', 'bim'),
                'off' => esc_html__('Hide', 'bim'),
                'default' => true,
            ],
            [
                'id' => 'post_single_page_title_bg_image',
                'type' => 'background',
                'title' => esc_html__('Background Image', 'bim'),
                'preview' => false,
                'preview_media' => true,
                'background-color' => false,
                'default' => [
                    'background-repeat' => 'repeat',
                    'background-size' => 'cover',
                    'background-attachment' => 'scroll',
                    'background-position' => 'center center',
                    'background-color' => '#101d27',
                ],
            ],
            [
                'id' => 'single_padding_layout_3',
                'type' => 'spacing',
                'mode' => 'padding',
                'all' => false,
                'bottom' => true,
                'top' => true,
                'left' => false,
                'right' => false,
                'title' => esc_html__('Padding Top/Bottom', 'bim'),
                'desc' => esc_html__('Note: this setting affects only the "Overlay Image" post layout.', 'bim'),
                'default' => [
                    'padding-top' => '320px',
                    'padding-bottom' => '0px',
                ],
            ],
            [
                'id' => 'blog_single_page_title-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_single_sidebar-start',
                'type' => 'section',
                'title' => esc_html__('Sidebar', 'bim'),
                'indent' => true,
            ],
            [
                'id' => 'single_sidebar_layout',
                'type' => 'image_select',
                'title' => esc_html__('Blog Single Sidebar Layout', 'bim'),
                'options' => [
                    'none' => [
                        'alt' => 'None',
                        'img' => get_template_directory_uri() . '/images/1co.png'
                    ],
                    'left' => [
                        'alt' => 'Left',
                        'img' => get_template_directory_uri() . '/images/2cl.png'
                    ],
                    'right' => [
                        'alt' => 'Right',
                        'img' => get_template_directory_uri() . '/images/2cr.png'
                    ]
                ],
                'default' => 'right'
            ],
            [
                'id' => 'single_sidebar_def',
                'type' => 'select',
                'title' => esc_html__('Blog Single Sidebar', 'bim'),
                'data' => 'sidebars',
                'default' => 'sidebar_main-sidebar',
                'required' => ['single_sidebar_layout', '!=', 'none'],
            ],
            [
                'id' => 'single_sidebar_def_width', 
                'type' => 'button_set',
                'title' => esc_html__('Blog Single Sidebar Width', 'bim'),
                'options' => [
                    '9' => '25%',
                    '8' => '33%',
                ],
                'default' => '8',
            ],
            [
                'id' => 'single_sidebar_sticky',
                'type' => 'switch',
                'title' => esc_html__('Blog Single Sticky Sidebar On?', 'bim'),
                'default' => true,
                'required' => ['single_sidebar_layout', '!=', 'none'],
            ],
            [
                'id' => 'single_sidebar_gap', 
                'type' => 'select',
                'title' => esc_html__('Sidebar Side Gap', 'bim'),
                'options' => [
                    'def' => esc_html__('Default', 'bim'),
                    '0' => '0',
                    '10' => '10',
                    '15' => '15',
                    '20' => '20',
                    '25' => '25',
                    '30' => '30',
                    '35' => '35',
                    '40' => '40',
                    '45' => '45',
                    '50' => '50',
                ],
                'default' => 'def',
                'required' => ['single_sidebar_layout', '!=', 'none'],
            ],
            [
                'id' => 'blog_single_sidebar-end',
                'type' => 'section',
                'indent' => false,
            ],
            [
                'id' => 'blog_single_appearance-start',
                'type' => 'section',
                'title' => esc_html__('Appearance', 'bim'),
                'indent' => true,
            ],
            [
                'id' => 'featured_image_type',
                'type' => 'button_set',
                'title' => esc_html__('Featured Image', 'bim'),
                'options' => [
                    'default' => esc_html__('Default', 'bim'),
                    'off' => esc_html__('Off', 'bim'),
                    'replace' => esc_html__('Replace', 'bim')
                ],
                'default' => 'default'
            ],
            [
                'id' => 'featured_image_replace',
                'type' => 'media',
                'title' => esc_html__('Image To Replace On', 'bim'),
                'required' => ['featured_image_type', '=', 'replace'],
            ],


            [
                'id' => 'blog_single_appearance-end',
                'type' => 'section',
                'indent' => false,
            ],
        ]
));

Redux::setSection($bim_pre,  array(
	'icon' => 'el-icon-lines',
	"subsection" => false,
	'title' => esc_html__('Side Panel', 'bim'),
	'desc' => esc_html__('Assign menu for side panel section.', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_sidepanel_set',
			'type'     => 'select',
			'title'    => esc_html__('Side Panel', 'bim'),
			'options' => array(
				'default' => esc_html__('Standard Side panel', 'bim'),
				'custom' => esc_html__('Custom Side panel', 'bim'),
			),
		),
		array(
			'id'    => 'bim_sidepanel_set_list',
			'type'  => 'select',
			'title'    => esc_html__('Side panel', 'bim'),
			'data'  => 'posts',
			'args'  => array(
				'post_type' => 'sidepanel',
				'orderby'   => 'title',
				'order'     => 'ASC',
			)
		),     
	),
));

Redux::setSection($bim_pre,  array(
	'id' => 'logo',
	"subsection" => false,
	'title' => esc_html__('Footer logo', 'bim'),
	'desc' => esc_html__('Configuration the style settings', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_footer_logo_white',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__('Logo White Text', 'bim'), 
			'subtitle' => esc_html__('Upload your logo for white text (standard) footer (Recommended size 240x80px)', 'bim'),
			'default'  => array('url'=>get_template_directory_uri().'/images/logo.png'),
		),

		array(
			'id'       => 'bim_footer_logo_dark',
			'type'     => 'media',
			'url'      => true,
			'title'    => esc_html__('Logo Dark Text', 'bim'), 
			'subtitle' => esc_html__('Upload your logo for dark text (standard) footer (Recommended size 240x80px)', 'bim'),
			'default'  => array('url'=>get_template_directory_uri().'/images/logo-white.png'),
		), 
		array(
			'id'       => 'bim_footer_text',
			'type'     => 'editor',
			'title'    => esc_html__('Footer Text', 'bim'), 
			'subtitle' => esc_html__('Upload your logo for dark text (standard) footer (Recommended size 240x80px)', 'bim'),
			'default' => '',
			'args'   => array('teeny'  => true,'textarea_rows'=> 10)
		), 
	)
));

Redux::setSection($bim_pre,  array(
	'id' => 'bim_footer_social',
	'icon' => 'el el-group-alt',
	"subsection" => false,
	'title' => esc_html__('Footer social', 'bim'),
	'desc' => esc_html__('Configuration the footer social icons', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_footer_enable_social',
			'type'     => 'switch',
			'title'    => esc_html__('Enable Footer Social', 'bim'), 
			'default'  => true,
		), 
		array(
			'id'       => 'bim_footer_facebook',
			'type'     => 'text',
			'title'    => esc_html__('Facebook Link', 'bim'), 
			'subtitle' => esc_html__('Input facebook link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		), 
		array(
			'id'       => 'bim_footer_tiktok',
			'type'     => 'text',
			'title'    => esc_html__('Tiktok Link', 'bim'), 
			'subtitle' => esc_html__('Input Tiktok link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		), 
		array(
			'id'       => 'bim_footer_twitter',
			'type'     => 'text',
			'title'    => esc_html__('Twitter Link', 'bim'), 
			'subtitle' => esc_html__('Input Twitter link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		), 
		array(
			'id'       => 'bim_footer_instagram',
			'type'     => 'text',
			'title'    => esc_html__('Instagram Link', 'bim'), 
			'subtitle' => esc_html__('Input Instagram link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		),  
		array(
			'id'       => 'bim_footer_pinterest',
			'type'     => 'text',
			'title'    => esc_html__('Pinterest Link', 'bim'), 
			'subtitle' => esc_html__('Input Pinterest link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		), 
		array(
			'id'       => 'bim_footer_xing',
			'type'     => 'text',
			'title'    => esc_html__('Xing Link', 'bim'), 
			'subtitle' => esc_html__('Input Xing link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		),  
		array(
			'id'       => 'bim_footer_linkedin',
			'type'     => 'text',
			'title'    => esc_html__('LinkedIn Link', 'bim'), 
			'subtitle' => esc_html__('Input LinkedIn link here', 'bim'),
			'required'  => array('bim_footer_enable_social', 'equals',true),
		),  
	)
));

Redux::setSection($bim_pre,  array(
	'id' => 'portfolio',
	'icon'=>'el el-briefcase',
	"subsection" => false,
	'title' => esc_html__('Portfolio setting', 'bim'),
	'desc' => esc_html__('Configuration portfolio settings', 'bim'),
	'fields' => array(
		array(
			'id'       => 'bim_portfolio_all',
			'type'     => 'text',
			'title'    => esc_html__('All categories filter', 'bim'), 
			'subtitle' => esc_html__('Portfolio Text Filter for all categories', 'bim'),
			'desc' => esc_html__('Insert your text for portfolio filter for all categories. The default text is "All"', 'bim'),
			'default'  => 'All',
		),  
		array(
			'id'       => 'bim_other_port_sub',
			'type'     => 'text',
			'title'    => esc_html__('Other Portfolio Section Subtitle', 'bim'), 
			'desc' => esc_html__('Insert your text for subt title of other portfolio section on single portfolio page.<br/>Leave it blank if you want to use the default text.', 'bim'),
			'default'  => 'See our other portfolio',
		),
		array(
			'id'       => 'bim_other_port_title',
			'type'     => 'text',
			'title'    => esc_html__('Other Portfolio Section Title', 'bim'), 
			'desc' => esc_html__('Insert your text for title of other portfolio section on single portfolio page.<br/>Leave it blank if you want to use the default text.', 'bim'),
			'default'  => 'Other portfolio',
		),
	),
));

Redux::setSection($bim_pre,  array(
	'id' => 'blog',
	'icon'=>'el el-bold',
	"subsection" => false,
	'title' => esc_html__('Blog setting', 'bim'),
	'desc' => esc_html__('Configuration blog settings', 'bim'),
	'fields' => array(

		array(
			'id'       => 'bim_sidebar_format', 
			'type'     => 'select',
			'title'    => esc_html__('Sidebar Format', 'bim'),
			'options' => array(
					'right_sidebar' => esc_html__( 'Right Sidebar', 'bim' ),
					'left_sidebar' => esc_html__( 'Left Sidebar','bim'),
					'no_sidebar' => esc_html__( 'No Sidebar', 'bim' ),
			),
			'default'  => 'right_sidebar', 
		),
		array(
			'id'       => 'bim_related_image',
			'type'     => 'select',
			'title'    => esc_html__('Featured Image in Related Posts', 'bim'),
			'options' => array(
					'show' => esc_html__('Show', 'bim'),
					'hide' => esc_html__('Hide', 'bim'),
			),
			'default'  => 'show',
		),

		array( 
			'id'       => 'bim_blog_slide_delay',
			'type'     => 'slider',
			'title'    => esc_html__('Blog Slider Delay', 'bim'), 
			'desc' => esc_html__('Insert the slider delay for slider in blog sidebar,blog wide and single blog post here. The default value 8000', 'bim'),
			'default'  => 8000,
			"min"       => 1,
			"step"      => 1,
			"max"       => 10000,
			'display_value' => 'label'
		),       
	),

));


/* Typography  */
Redux::setSection($bim_pre,  array(
    'icon' => 'el el-fontsize',
    'title' => esc_html__('Typography', 'bim'),
    'desc' => esc_html__('Font settings', 'bim'),
    'fields' => array(
        array(
            'id'        => 'opt-accordion-begin-general',
            'type'      => 'accordion',
            'title'     => esc_html__('Font Family', 'bim'),
            'subtitle'  => esc_html__('Set font family', 'bim'),
            'position'  => 'start',
        ),
        array(
            'id'       => 'main_font',
            'type'     => 'typography',
            'title'    => esc_html__( 'Main Font', 'bim' ),
            'font-size'=> false,
            'line-height'=> false,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'default'  => array(
                'font-family' => 'Roboto',
            ),
            'output' => array('body')
        ),
        array(
            'id'       => 'headers_font',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header Fonts', 'bim' ),
            'font-size'=> false,
            'line-height'=> false, 
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'default'  => array(
                'font-family' => 'Poppins',
            ),
            'output' => array('h1, h2, h3, h4, h5, h6')
        ),

        array(
            'id'        => 'opt-accordion-end-general',
            'type'      => 'accordion',
            'position'  => 'end'
        ),

        /* Font Size and Line Height */ 
        
        array(
            'id'        => 'opt-accordion-begin-general',
            'type'      => 'accordion',
            'title'     => esc_html__('Font Size', 'bim'),
            'subtitle'  => esc_html__('Set font size', 'bim'), 
            'position'  => 'start',
        ),
        array(
            'id'       => 'body_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Body Font Size', 'bim' ),
            'line-height'=> true,
            'font-size'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '14px',
                'line-height' => '25px',
            ),
            'output' => array('body')
        ),
        array(
            'id'       => 'header_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Header Font Size', 'bim' ),
            'font-size'=> true,
            'line-height'=> false,
            'color' => false,   
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'line-height' => '1.4em',
            ),
            'output' => array('h1, h2, h3, h4, h5, h6'),
        ),

        array(
            'id'       => 'h4_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h4 Font Size', 'bim' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '20px',
            ),
            'output' => array('h4')
        ),
        array(
            'id'       => 'h5_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h5 Font Size', 'bim' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '18px',
            ),
            'output' => array('h5')
        ),
        array(
            'id'       => 'h6_font_size',
            'type'     => 'typography',
            'title'    => esc_html__( 'Heading h6 Font Size', 'bim' ),
            'font-size'=> true,
            'line-height'=> true,
            'color' => false,
            'text-align' => false,
            'font-style' => false,
            'font-weight'=> false,
            'subsets' => false,
            'font-family' => false,
            'preview'     => false,
            'default'     => array(
                'font-size'   => '17px',
            ),
            'output' => array('h6')
        ),

        array(
            'id'        => 'opt-accordion-end-general',
            'type'      => 'accordion',
            'position'  => 'end'
        ),
    )
));

?>