<?php
define("ITEM_PLUGIN_DOMAIN","bim_plg_load");
define("ITEM_THEME_NAME","Bim");  
define("item_id","26437882"); 
define("item_theme_version","1.3.8");
define('TCG_THEME_ELEMENTS',true);

/*============================================== After plugin Load ============================================*/

// ## Add action hook a function executed after the theme is loaded and set up.
add_action( 'after_setup_theme', 'themescamp_theme_setup' );
function themescamp_theme_setup() {
    
    if (defined('TCG_THEME_DEV_MOD') && TCG_THEME_DEV_MOD === true) {
        update_option('tcg_theme_dev_mod', true);
    } else{update_option('tcg_theme_dev_mod', false);}

    if (defined('TCG_THEME_ELEMENTS') && TCG_THEME_ELEMENTS === true) {
        update_option('tcg_theme_elements', true);
    } else{update_option('tcg_theme_elements', false);}
}

/* Add the registration custom page */
add_action('admin_menu','tcg_registration_menu',9);
function tcg_registration_menu() {

    global $license_status;
    $license_status = get_option('license_status', '');
    add_menu_page('Register '.ITEM_THEME_NAME,ITEM_THEME_NAME.' theme','manage_options','registration','tcg_registration_page','dashicons-align-center',4);
    add_submenu_page('registration',ITEM_THEME_NAME.' Settings', 'Theme Options','manage_options','bim_theme_settings','bim_theme_settings');
    add_submenu_page('registration','Import demo','Import demo','manage_options','one-click-demo-import','bim_theme_settings');
    add_submenu_page(null, ITEM_THEME_NAME.' Settings', 'Theme Options', 'manage_options', 'bim_theme_settings_hidden', 'bim_theme_settings');

}

/*============================================== Common license ============================================*/

class Tcg_Register_Page {
    public function deactivate_license_link() {
        if ( isset($_GET['deactivate_license']) && $_GET['deactivate_license'] == '1') {
            update_option('license_status', 'Inactive');
            update_option('saved_license_key', '');
            update_option('license_type', '');
        }
        $saved_license_key = get_option('saved_license_key', ''); // Default to empty string

        $revoke_url = "https://doc.themescamp.com/support/?license_key={".$saved_license_key."}&blog=" . urlencode(site_url());

        return apply_filters("deactivate_license_link", add_query_arg(
            array(
                'license_key' => $saved_license_key,
                'deactivate-license' => true,
            ),
            $revoke_url
        ));
    }
}
function tcg_registration_page() {

    $is_successful = isset($_GET['success']) && $_GET['success'] == '1';
    $token = isset($_GET['token']) ? sanitize_text_field($_GET['token']) : '';

    if (!empty($token) & $is_successful) {
        update_option('saved_license_key', $token);
        update_option('license_status', 'Active');  // Set the license status to 'Active'
        update_option('license_type', 'key');  
    }
    global $license_status;
    $saved_license_key = get_option('saved_license_key', '');
    $license_status = get_option('license_status', '');  // Get the license status from the database


    if ($license_status == 'Active') {
        $intro = esc_html__('Thank you for choosing '.ITEM_THEME_NAME.'! Your product is already registered, so you have access to:',ITEM_THEME_NAME);
        $title = esc_html__('Congratulations! Your product is registered now.','bim_plg');
        $icon  = 'yes';
        $class = 'is-registered';
    }else {
        $intro = esc_html__('Thank you for choosing '.ITEM_THEME_NAME.'! Registering your product allows you to:','bim_plg');
        $title = esc_html__('Click on the button below to begin the registration process.','bim_plg');
        $icon  = 'no';
        $class = 'not-registered';
    }
?>

    <div id="tcg-registration-wrap" class="tcg-demos-container  <?php echo esc_attr($class)?>">
        <div class="tcg-dash-container tcg-dash-container-medium">
            <div class="postbox">
                <h2><span><?php echo esc_html__('Welcome to',ITEM_THEME_NAME).' '.ITEM_THEME_NAME.'!';?></span></h2>


                <div class="inside">
                    <div class="main">
                        <h3 class="tcg-dash-margin-remove"><span class="dashicons dashicons-<?php echo esc_attr($icon);?> library-icon-key"></span> <?php echo ($title);?></h3>


                                <?php
                                    if ($is_successful) {
                                        echo '<div class="notice notice-success">Registration Successful!</div>';
                                    }

                                    if ($license_status == 'Active' && get_option('license_type') === 'key') {
                                        echo '<p>Your License Key <small> ( purchase code )</small>: <strong>' . esc_html($saved_license_key) . '</strong></p>';
                                    }

                                ?>

                        <p class="tcg-dash-text-lead"><?php echo ($intro);?></p>
                        <ul>
                            <li><i class="dashicons dashicons-update"></i><?php echo esc_html__('An update mechanism','bim_plg')?></li>
                            <li class="tcg-license-support <?php echo (get_option('license_type') === 'token') ? 'hidden' : ''; ?>"><i class="dashicons dashicons-businessman "></i><a target="_blank" href="https://themescamp.ticksy.com/"><?php echo esc_html__('Access to support','bim_plg')?></a></li>
                        </ul>

                        <div>
                            <?php if (get_option('tcg_theme_elements')){ ?>
                            <input type="checkbox" id="tcg-envato-elements-cb" name="tcg_envato_elements" value="code" <?php echo (get_option('license_type') === 'token') ? 'checked="checked"' : ''; ?>>
                            <span class="elements-license-select"><?php esc_attr_e('I downloaded the theme from Envato Elements.', 'bim_plg'); ?></span>
                            <?php }?>
                            <form method="post" action="" id="tcg-elements-token" class="<?php echo (get_option('license_type') !== 'token') ? 'hidden' : ''; ?>">
                                <?php wp_nonce_field('customer_plugin_nonce', 'customer_plugin_nonce_field'); ?>
                                <table class="form-table">
                                    <tr valign="top">
                                        <th scope="row" class="elements-license-select"><?php esc_html_e('Enter your Envato Elements Token*', 'bim_plg'); ?></th>
                                        <td>
                                            <input type="text" name="token" value="<?php echo esc_attr(get_option('customer_plugin_token')); ?>" class="token" placeholder="XXXXXX-XXX-XXXX-XXXX-XXXXXXXX"> 
                                            <input type="text" name="tcg_token_email" value="<?php echo esc_attr(get_option('tcg_token_email')); ?>" placeholder="<?php esc_attr_e('Your e-mail', 'bim_plg'); ?>" class="token-email">
                                            <p id="tcg-code-help-elements" class="">
                                                <?php
                                                $extension_id = md5(get_site_url());
                                                $activation_link = sprintf(
                                                    '<a href="https://api.extensions.envato.com/extensions/begin_activation?extension_id=%s&amp;extension_type=envato-wordpress&amp;extension_description=WPTheme" target="_blank">Follow this link to generate a new Envato Elements Token.</a>',
                                                    $extension_id
                                                );
                                                echo $activation_link;
                                                ?>
                                            </p>
                                            <input type="checkbox" name="tcg_addons_user_agree" value="1" checked="checked">
                                            <?php
                                                echo sprintf(
                                                        wp_kses( __('Your data is processed in accordance with our %s.', 'bim_plg'), 'tcg_addons_kses_content' ),
                                                        '<a class="tcg-policy-link" href="' . apply_filters('tcg_addons_filter_privacy_url', '//themescamp.com/terms-policy/#privacy-policy') . '" target="_blank">' . esc_html__('Privacy Policy', 'bim_plg') . '</a>'
                                                        );
                                            ?>
                                        </td>
                                    </tr>
                                </table>

                                <div <?php echo (get_option('license_status') === 'Active') ? 'class="hidden"' : ''; ?>> 
                                    <?php submit_button('Activate License Token'); ?> 
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
                <div id="license-footer" class="community-events-footer">

                    <?php if ($license_status == 'Active') {   global $item_updater; $item_updater = new Tcg_Register_Page(); update_option('tcg_theme_status','active'); ?>
                        <div class="tcg-support-status tcg-support-status-active">
                            <?php esc_html_e('License Status:', 'bim_plg'); ?> <span><?php echo esc_html($license_status); ?></span>

                            <a class="button <?php echo (get_option('license_type') === 'token') ? 'hidden' : ''; ?>" href="<?php echo $item_updater->deactivate_license_link(); ?>"><?php esc_html_e('Revoke License Key', 'bim_plg'); ?></a>

                            <a class="button <?php echo (get_option('license_type') === 'key' || get_option('license_type') === 'Pkey') ? 'hidden' : ''; ?>" href="<?php echo esc_url(add_query_arg('revoke_elements_token', '1')); ?>"><?php esc_html_e('Revoke Elements Token', 'bim_plg'); ?></a>

                        </div>

                    <?php } else { delete_option('tcg_theme_status'); ?>
                        <div class="tcg-registration-wrap">
                            <a href="<?php echo tcg_activate_link();?>" class="button button-primary tcg-register"><?php esc_html_e('Register Now!', 'bim_plg'); ?></a>
                            <div>
                                <input type="checkbox" id="tcg-envato-market-key-cb" name="tcg_envato_elements" value="code" <?php echo (get_option('license_type') === 'token') ? 'checked="checked"' : ''; ?>>
                                <span class="elements-license-select"><?php esc_attr_e('Verify via purchase code (Alternative of Register).', 'bim_plg'); ?></span>
                            </div>
                            <form method="post" action="" id="tcg-market-key" class="<?php echo (get_option('license_type') !== 'Pkey') ? 'hidden' : ''; ?>">
                                <?php wp_nonce_field('purchase_key_nonce', 'purchase_key_nonce_field'); ?>
                                <table class="form-table">
                                    <tr valign="top">
                                        <th scope="row" class="elements-license-select"><?php esc_html_e('Enter your Purchase code*', 'bim_plg'); ?></th>
                                        <td>
                                            <input type="text" name="purchase_key" value="<?php echo esc_attr(get_option('tcg_purchase_key')); ?>" class="token" placeholder="XXXXXX-XXX-XXXX-XXXX-XXXXXXXX"> 
                                            <input type="text" name="purchase_key_email" value="<?php echo esc_attr(get_option('tcg_purchase_key_email')); ?>" placeholder="<?php esc_attr_e('Your e-mail', 'bim_plg'); ?>" class="token-email">
                                            <p id="tcg-code-help-elements" class="">
                                                <?php
                                                $extension_id = md5(get_site_url());
                                                $activation_link = sprintf(
                                                    '<a href="https://prnt.sc/MZ1yPEGKtNfG" target="_blank">Here You can find the Purchase code from Your downloads.</a>',
                                                    $extension_id
                                                );
                                                echo $activation_link;
                                                ?>
                                            </p>
                                            <input type="checkbox" name="tcg_addons_user_agree" value="1" checked="checked">
                                            <?php
                                                echo sprintf(
                                                        wp_kses( __('Your data is processed in accordance with our %s.', 'bim_plg'), 'tcg_addons_kses_content' ),
                                                        '<a class="tcg-policy-link" href="' . apply_filters('tcg_addons_filter_privacy_url', '//themescamp.com/terms-policy/#privacy-policy') . '" target="_blank">' . esc_html__('Privacy Policy', 'bim_plg') . '</a>'
                                                        );
                                            ?>
                                        </td>
                                    </tr>
                                </table>

                                <div <?php echo (get_option('license_status') === 'Active') ? 'class="hidden"' : ''; ?>> 
                                    <?php submit_button('Activate License'); ?> 
                                </div>

                            </form>
                        </div>

                        <?php 
                    }?>
                </div>
            </div>
        </div>
    </div>
    <?php


}

function tcg_activate_link(){

    $redirect_url = urlencode(admin_url('admin.php?page=registration&envato_verify_purchase=1'));
    $initiate_url = "https://doc.themescamp.com/support/?item={".item_id."}&blog=" . urlencode(site_url()) . "&redirect_url={$redirect_url}";

    return apply_filters( "activate_license_link", add_query_arg(
        array(
            'item'         => item_id,
        ),
        $initiate_url
    ));
}


 

add_action('admin_init', 'customer_plugin_handle_token');

function customer_plugin_handle_token() {
    if (isset($_POST['customer_plugin_nonce_field']) && wp_verify_nonce($_POST['customer_plugin_nonce_field'], 'customer_plugin_nonce')) {
        if (isset($_POST['token'])) {
            $token = sanitize_text_field($_POST['token']);
            $token_email = sanitize_text_field($_POST['tcg_token_email']);
            update_option('customer_plugin_token', $token);
            update_option('tcg_token_email', $token_email);

            $extension_id = md5(get_site_url());
            $url_token =get_site_url();
            $theme_id =item_id;
            $item_name =ITEM_THEME_NAME;


            $response = wp_remote_post('https://doc.themescamp.com/wp-json/envato-elements/v1/verify-token', array(
                'body' => array(
                    'token' => $token,
                    'token_email' => $token_email,
                    'extension_id' => $extension_id, // Include extension ID here
                    'url_token' => $url_token,
                    'theme_id' => $theme_id,
                    'item_name' => $item_name,
                ),
                'timeout' => 15,
            ));

            if (is_wp_error($response)) {
                add_settings_error('customer_plugin_messages', 'customer_plugin_message', __('Token verification failed.', 'bim_plg'), 'error');
            } else {
                $body = wp_remote_retrieve_body($response);
                $result = json_decode($body, true);

                if (isset($result['success']) && $result['success']) {
                    add_settings_error('customer_plugin_messages', 'customer_plugin_message', __('Token verified successfully.', 'bim_plg'), 'updated');
                    update_option('license_status', 'Active');  // Set the license status to 'Active'
                    update_option('license_type', 'token');  // Set the license status to 'Active'

                } else {
                    $error_message = isset($result['message']) ? $result['message'] : __('Invalid Token key.', 'bim_plg');
                    add_settings_error('customer_plugin_messages', 'customer_plugin_message', $error_message, 'error');
                    update_option('license_status', '');  // Set the license status to 'Active'
                    update_option('license_type', '');  // Set the license status to 'Active'
                    //update_option('customer_plugin_token', '');
                }
            }
        }
    }
}


add_action('admin_notices', 'customer_plugin_admin_notices');

function customer_plugin_admin_notices() {
    settings_errors('customer_plugin_messages');
}

function handle_revoke_elements_token() {
    if (isset($_GET['revoke_elements_token']) && $_GET['revoke_elements_token'] == '1') {
        // Update the license status to 'Inactive'
        update_option('license_status', 'Inactive');
        update_option('license_type', '');  // Set the license status to 'Active'
        
        // Optionally, you can also clear the saved license key
        update_option('customer_plugin_token', '');
        
        // Redirect to remove the query parameter from the URL and bimid repeated actions on refresh
        wp_redirect(remove_query_arg('revoke_elements_token'));
        exit;
    }
}
add_action('admin_init', 'handle_revoke_elements_token');





add_action('admin_init', 'tcg_handle_purchase_key');

function tcg_handle_purchase_key() {
    if (isset($_POST['purchase_key_nonce_field']) && wp_verify_nonce($_POST['purchase_key_nonce_field'], 'purchase_key_nonce')) {
        if (isset($_POST['purchase_key'])) {
            $purchase_key = sanitize_text_field($_POST['purchase_key']);
            $purchase_key_email = sanitize_text_field($_POST['purchase_key_email']);
            update_option('tcg_purchase_key', $purchase_key);
            update_option('tcg_purchase_key_email', $purchase_key_email);

            $url_pkey =get_site_url();
            $theme_id =item_id;
            $item_name =ITEM_THEME_NAME;

            $pkey_response = wp_remote_post('https://doc.themescamp.com/wp-json/envato-market/v1/verify-key', array(
                'body' => array(
                    'purchase_key' => $purchase_key,
                    'purchase_key_email' => $purchase_key_email,
                    'url_pkey' => $url_pkey,
                    'theme_id' => $theme_id,
                    'item_name' => $item_name,
                ),
                'timeout' => 15,
            ));

            if (is_wp_error($pkey_response)) {
                add_settings_error('customer_plugin_messages', 'customer_plugin_message', __('Purchase code verification failed.', 'bim_plg'), 'error');
            } else {
                $body = wp_remote_retrieve_body($pkey_response);
                $result = json_decode($body, true);

                if (isset($result['success']) && $result['success'] && isset($result['data']['item']['id']) && $result['data']['item']['id'] == $theme_id) {
                    add_settings_error('customer_plugin_messages', 'customer_plugin_message', __('Purchase code verified successfully.', 'bim_plg'), 'updated');
                    update_option('license_status', 'Active');  // Set the license status to 'Active'
                    update_option('license_type', 'Pkey');  // Set the license status to 'Active'

                } else {
                    $error_message = isset($result['message']) ? $result['message'] : __('Invalid Purchase code.', 'bim_plg');
                    add_settings_error('customer_plugin_messages', 'customer_plugin_message', $error_message, 'error');
                    update_option('license_status', '');  // Set the license status to 'Active'
                    update_option('license_type', '');  // Set the license status to 'Active'
                    //update_option('customer_plugin_token', '');
                }
            }
        }
    }
}
